﻿/*
 @author Comevents (Adrien)
 Ce fichier permet aux utilisateurs de gérer les cookies
Remarques:
    - Valeur à modifier Pour Google Analytics-> gaProperty (UA-XXXXXXXX-YY) est unique à chaque site
    - La page pour parametrer les cookies doit être accesible à l'url /cookies
    - hasConsent permet de définir si l'utilisateur a fait un choix afin de dire si on doit afficher le bandeau
    - ga-disable-... est le choix de l'utilisateur concernant les cookies de Google Analytics
*/

// Fonctions générales ===========================================================
  // Remplacez la valeur UA-XXXXXXXX-YY par l'identifiant analytics de votre site.
  var gaProperty = 'UA-10979406-29';
  // Chox de l'utilisateur
  var disableStr = 'ga-disable-' + gaProperty; // concernant les cookies de Google Analytics
  var consentCookie =  getCookie('hasConsent'); // permet de savoir si on doit afficher le bandeau ou non  
  
  // Ce bout de code vérifie que le consentement n'a pas déjà été obtenu avant d'afficher la baniére
  if (!consentCookie) {//L'utilisateur n'a pas encore de cookie de consentement
   var referrer_host = document.referrer.split('/')[2]; 
     if (referrer_host != document.location.hostname) { //si il vient d'un autre site
        // On désactive le tracking
       window[disableStr] = true;
       // Affichage du bandeau pour la demande de consentement
       document.addEventListener('DOMContentLoaded', function(event) {
          cookieChoices.showCookieConsentBar('En poursuivant votre navigation sur ce site, vous acceptez l\'utilisation des cookies. ',
            'OK', 'En savoir plus',  'http://www.manucentre.fr/cookies'); // TODO AUTOMATISER L'APPEL DE CETTE PAGE
        });
     } else { 
        // sinon on lui dépose un cookie validant son consentement si il n'est pas sur la page d'accueil ou de paramètre des cookies 
        // (cas le visiteur navigue dans le site)
        if(window.location.pathname != '/' && window.location.pathname != '/cookies') {
          document.cookie = 'hasConsent=true; '+ getCookieExpireDate() +' ; path=/'; 
        }
     }
  }
      
  // Fonction permettant de récupérer la valeur d'un cookie à partir de ce nom
  function getCookie(NomDuCookie)  {
      if (document.cookie.length > 0) {        
          begin = document.cookie.indexOf(NomDuCookie+"=");
          if (begin != -1)  {
              begin += NomDuCookie.length+1;
              end = document.cookie.indexOf(";", begin);
              if (end == -1) end = document.cookie.length;
              return unescape(document.cookie.substring(begin, end)); 
          }
       }
      return null;
  }

  // Fonction d'effacement des cookies   
  function delCookie(name)   {
      path = ";path=" + "/";
      domain = ";domain=" + "."+document.location.hostname;
      var expiration = "Thu, 01-Jan-1970 00:00:01 GMT";       
      document.cookie = name + "=" + path + domain + ";expires=" + expiration;
  }

// Cookies Google Analytics ========================================================
    
    //Cette fonction retourne la date d'expiration du cookie de consentement 
    function getCookieExpireDate() { 
      var cookieTimeout = 34214400000;// Le nombre de millisecondes que font 13 mois 
      var date = new Date();
      date.setTime(date.getTime()+cookieTimeout);
      var expires = "; expires="+date.toGMTString();
      return expires;
    }
             
    // Efface tous les types de cookies utilisés par Google Analytics    
    function deleteAnalyticsCookies() {
        var cookieNames = ["__utma","__utmb","__utmc","__utmz","_ga", "__utmt"]
        for (var i=0; i<cookieNames.length; i++)
            delCookie(cookieNames[i])
    }
       
    // Autorisation des cookies Google Analytics
    function gaOptoutAnalytics() {
        document.cookie = disableStr + '=true;'+ getCookieExpireDate() +' ; path=/';   
        document.cookie = 'hasConsent=false;'+ getCookieExpireDate() +' ; path=/';
        var repGoogle = document.getElementById('repGoogle');
        // Code de la bannière affichée une fois que l'utilisateur s'est opposé au dépôt
        if (repGoogle!= null) repGoogle.innerHTML = "<div class='repCookies'>Vous vous êtes opposé au dépôt de cookies de mesures d\'audience dans votre navigateur.<br/><a href='javascript:gaOptoutAnalyticsOK()'>&#183; Cliquez ici si vous souhaitez les autoriser à nouveau.</a></div>";
        window[disableStr] = true;
        deleteAnalyticsCookies();
    }
    
    // Refus des cookies Google Analytics
    function gaOptoutAnalyticsOK(){
      document.cookie = disableStr + '=; expires=Thu, 01 Jan 1970 00:00:01 GMT;'; // suppression du cookie
      document.cookie = 'hasConsent=true;'+ getCookieExpireDate() +' ; path=/';
      if ( repGoogle!= null ) repGoogle.innerHTML = "<div class='repCookies'>Vous autorisez le dépôt de cookies de mesures d\'audience dans votre navigateur.<br/><a href='javascript:gaOptoutAnalytics()'>&#183; Cliquez ici si vous souhaitez vous y opposer.</a></div>";
    }    
    
    // On efface constamment les cookies de Google Analytics tant que l'utilisateur n'a pas navigué
    if(!getCookie('ga-disable-'+gaProperty)) { // si ce cookie n'existe pas
      //if(window.location.pathname == '/' || window.location.pathname == '/cookies'){ // s'il l'utilisateur n'est ni sur l'accueil ni sur la page cookies
        if(!getCookie('hasConsent')) { // si ce cookie n'existe pas
          deleteAnalyticsCookies();
        }
      //}
      if(window.location.pathname == '/cookies'){
        // Affiche le choix de l'utilisateur sur la page de gestion des cookies
        var repGoogle = document.getElementById('repGoogle'); 
        repGoogle.innerHTML = "<div class='repCookies'>Vous autorisez le dépôt de cookies de mesures d\'audience dans votre navigateur.<br/><a href='javascript:gaOptoutAnalytics()'>&#183; Cliquez ici si vous souhaitez vous y opposer.</a></div>";
      }
    }
    else {
      // Si le cookies existe c'est que l'utilisateur les as refusés.
      deleteAnalyticsCookies();
      if(window.location.pathname == '/cookies'){
        // Affiche le choix de l'utilisateur sur la page de gestion des cookies
        var repGoogle = document.getElementById('repGoogle'); 
        repGoogle.innerHTML = "<div class='repCookies'>Vous vous êtes opposé au dépôt de cookies de mesures d\'audience dans votre navigateur.<br/><a href='javascript:gaOptoutAnalyticsOK()'>&#183; Cliquez ici si vous souhaitez les autoriser.</a></div>";
      }
    }
       

//  Réseaux sociaux (Like box with faces de Facebook -> voir module com_reseaux_sociaux) =====================================

  // Affiche le choix de l'utilisateur sur la page de gestion des cookies
  if(!getCookie('rs-disable')) { // si ce cookie n'existe pas
    if(window.location.pathname == '/cookies'){
      var repReseaux = document.getElementById('repReseaux');
      repReseaux.innerHTML = "<div class='repCookies'>Vous autorisez le dépôt de cookies utilisés par les réseaux sociaux.<br/><a href='javascript:cookiesReseauRefus()'>&#183; Cliquez ici si vous souhaitez vous y opposer.</a></div>";
    }
  }
  else {
    // Si le cookies existe c'est que l'utilisateur les as refusés.
    deleteFacebookCookies();
    if(window.location.pathname == '/cookies'){
      var repReseaux = document.getElementById('repReseaux'); 
      repReseaux.innerHTML = "<div class='repCookies'>Vous vous êtes opposé au dépôt des cookies utilisés par les réseaux sociaux.<br/><a href='javascript:cookiesReseauOK()'>&#183; Cliquez ici si vous souhaitez les autoriser.</a></div>";
    }
  }

  // Autorisation des cookies des réseaux sociaux
  function cookiesReseauOK(){
    document.cookie = 'rs-disable' + '=; expires=Thu, 01 Jan 1970 00:00:01 GMT;'; // suppression du cookie
    var repReseaux = document.getElementById('repReseaux');
    // Code de la bannière affichée une fois que l'utilisateur s'est opposé au dépôt
    if (repReseaux!= null) repReseaux.innerHTML = "<div class='repCookies'>Vous autorisez le dépôt de cookies utilisés par les réseaux sociaux.<br/><a href='javascript:cookiesReseauRefus()'>&#183; Cliquez ici si vous souhaitez vous y opposer.</a></div>";
  }   
  // Refus des cookies des réseaux sociaux
  function cookiesReseauRefus(){
    deleteFacebookCookies();
    window.localStorage.clear();
    document.cookie = 'rs-disable=true;'+ getCookieExpireDate() +' ; path=/'; 
    var repReseaux = document.getElementById('repReseaux');
    // Code de la bannière affichée une fois que l'utilisateur s'est opposé au dépôt
    if (repReseaux!= null) repReseaux.innerHTML = "<div class='repCookies'>Vous vous êtes opposé au dépôt des cookies utilisés par les réseaux sociaux.<br/><a href='javascript:cookiesReseauOK()'>&#183; Cliquez ici si vous souhaitez les autoriser.</a></div>";
  }

  // Efface tous les cookies utilisés par Facebook (ne fonctionne pas sur Chrome)
  function deleteFacebookCookies() {
    var cookieNames = ["lu","datr","act","x-src","c_user", "fr", "xs", "csm", "s"]
    for (var i=0; i<cookieNames.length; i++)
      delCookie(cookieNames[i])
  } 

// Contenu de cookiechoices.js=====================================================
/*
 Copyright 2014 Google Inc. All rights reserved.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

(function(window) {

  if (!!window.cookieChoices) {
    return window.cookieChoices;
  }

  var document = window.document;
  // IE8 does not support textContent, so we should fallback to innerText.
  var supportsTextContent = 'textContent' in document.body;

  var cookieChoices = (function() {

    var cookieName = 'displayCookieConsent';
    var cookieConsentId = 'cookieChoiceInfo';
    var dismissLinkId = 'cookieChoiceDismiss';

    function _createHeaderElement(cookieText, dismissText, linkText, linkHref) {

      var cookieConsentElement = document.createElement('div');
      cookieConsentElement.id = cookieConsentId;
      cookieConsentElement.appendChild(_createConsentText(cookieText));

      if (!!linkText && !!linkHref) {
        cookieConsentElement.appendChild(_createInformationLink(linkText, linkHref));
      }
      cookieConsentElement.appendChild(_createDismissLink(dismissText));
      return cookieConsentElement;
    }

    function _createDialogElement(cookieText, dismissText, linkText, linkHref) {
      var glassStyle = 'position:fixed;width:100%;height:100%;z-index:999;' +
          'top:0;left:0;opacity:0.5;filter:alpha(opacity=50);' +
          'background-color:#ccc;';
      var dialogStyle = 'z-index:1000;position:fixed;left:50%;top:50%';
      var contentStyle = 'position:relative;left:-50%;margin-top:-25%;' +
          'background-color:#fff;padding:20px;box-shadow:4px 4px 25px #888;';

      var cookieConsentElement = document.createElement('div');
      cookieConsentElement.id = cookieConsentId;

      var glassPanel = document.createElement('div');
      glassPanel.style.cssText = glassStyle;

      var content = document.createElement('div');
      content.style.cssText = contentStyle;

      var dialog = document.createElement('div');
      dialog.style.cssText = dialogStyle;

      var dismissLink = _createDismissLink(dismissText);
      dismissLink.style.display = 'block';
      dismissLink.style.textAlign = 'right';
      dismissLink.style.marginTop = '8px';

      content.appendChild(_createConsentText(cookieText));
      if (!!linkText && !!linkHref) {
        content.appendChild(_createInformationLink(linkText, linkHref));
      }
      content.appendChild(dismissLink);
      dialog.appendChild(content);
      cookieConsentElement.appendChild(glassPanel);
      cookieConsentElement.appendChild(dialog);
      return cookieConsentElement;
    }

    function _setElementText(element, text) {
      if (supportsTextContent) {
        element.textContent = text;
      } else {
        element.innerText = text;
      }
    }

    function _createConsentText(cookieText) {
      var consentText = document.createElement('span');
      _setElementText(consentText, cookieText);
      return consentText;
    }

    function _createDismissLink(dismissText) {
      var dismissLink = document.createElement('a');
      _setElementText(dismissLink, dismissText);
      dismissLink.id = dismissLinkId;
      dismissLink.href = '#';
      dismissLink.style.marginLeft = '24px';
      return dismissLink;
    }

    function _createInformationLink(linkText, linkHref) {
      var infoLink = document.createElement('a');
      _setElementText(infoLink, linkText);
      infoLink.href = linkHref;
      infoLink.target = '_blank';
      infoLink.style.marginLeft = '8px';
      return infoLink;
    }

    function _dismissLinkClick() {
      _saveUserPreference();
      _removeCookieConsent();
      return false;
    }

    function _showCookieConsent(cookieText, dismissText, linkText, linkHref, isDialog) {
      if (_shouldDisplayConsent()) {
        _removeCookieConsent();
        var consentElement = (isDialog) ?
            _createDialogElement(cookieText, dismissText, linkText, linkHref) :
            _createHeaderElement(cookieText, dismissText, linkText, linkHref);
        var fragment = document.createDocumentFragment();
        fragment.appendChild(consentElement);
        document.body.appendChild(fragment.cloneNode(true));
        document.getElementById(dismissLinkId).onclick = _dismissLinkClick;
      }
    }

    function showCookieConsentBar(cookieText, dismissText, linkText, linkHref) {
      _showCookieConsent(cookieText, dismissText, linkText, linkHref, false);
    }

    function showCookieConsentDialog(cookieText, dismissText, linkText, linkHref) {
      _showCookieConsent(cookieText, dismissText, linkText, linkHref, true);
    }

    function _removeCookieConsent() {
      var cookieChoiceElement = document.getElementById(cookieConsentId);
      if (cookieChoiceElement != null) {
        cookieChoiceElement.parentNode.removeChild(cookieChoiceElement);
      }
    }

    function _saveUserPreference() {
      // Set the cookie expiry to one year after today.
      var expiryDate = new Date();
      expiryDate.setFullYear(expiryDate.getFullYear() + 1);
      document.cookie = cookieName + '=y; expires=' + expiryDate.toGMTString();
    }

    function _shouldDisplayConsent() {
      // Display the header only if the cookie has not been set.
      return !document.cookie.match(new RegExp(cookieName + '=([^;]+)'));
    }

    var exports = {};
    exports.showCookieConsentBar = showCookieConsentBar;
    exports.showCookieConsentDialog = showCookieConsentDialog;
    return exports;
  })();

  window.cookieChoices = cookieChoices;
  return cookieChoices;
})(this);
