<?php

/**
 * @file
 * Default theme implementation to display the simplenews block.
 * 
 * Copy this file in your theme directory to create a custom themed block.
 * Rename it to simplenews-block--<tid>.tpl.php to override it for a 
 * newsletter using the newsletter term's id.
 *
 * Available variables:
 * - $subscribed: the current user is subscribed to the $tid newsletter
 * - $user: the current user is authenticated
 * - $tid: tid of the newsletter
 * - $message: announcement message (Default: 'Stay informed on our latest news!')
 * - $form: newsletter subscription form *1
 * - $subscription_link: link to subscription form at 'newsletter/subscriptions' *1
 * - $newsletter_link: link to taxonomy list of the newsletter issue *2
 * - $issue_list: list of newsletter issues (of the $tid newsletter series) *2
 * - $rssfeed: RSS feed of newsletter (series) *2
 * Note 1: requires 'subscribe to newsletters' permission
 * Note 2: requires 'view links in block' or 'administer newsletters' permission
 *
 * Simplenews module controls the display of the block content. The following
 * variables are available for this purpose:
 *  - $use_form       : TRUE = display the form; FALSE = display link to example.com/newsletter/subscriptions
 *  - $use_issue_link : TRUE = display link to newsletter issue list
 *  - $use_issue_list : TRUE = display list of the newsletter issue
 *  - $use_rss        : TRUE = display RSS feed
 *
 * @see template_preprocess_simplenews_block()
 */
global $base_url;
?>
<div class="popup_newsletter">

  <div class="logo_moudenc">
    <img src="<?php print $base_url.'/'.path_to_theme(); ?>/images/logo-moudenc-popup.jpg" alt="Jean Luc Moudenc" />
  </div><!-- Fin logo_moudenc -->

  <div class="slogan">
    <span class="gros_texte">Restez connectés,</span><br/>
    Ne manquez rien de la campagne !
  </div><!-- Fin slogan -->

  <?php if ($message): ?>
    <p><?php print $message; ?></p>
  <?php endif; ?>

  <div class="form_simplenews">
    <span class="label_mail">Recevez notre newsletter</span>
    <?php if ($use_form): ?>
      <?php print render($form); ?>
    <?php elseif ($subscription_link): ?>
      <p><?php print $subscription_link; ?></p>
    <?php endif; ?>
  </div><!-- Fin form_simplenews -->
  
  <?php 
  if(isset($_SESSION['affiche_message_popup']) && $_SESSION['affiche_message_popup'] == true)
  {
      $message = drupal_get_messages(NULL, FALSE);
      if(isset($message['error']))
      {
        print '<div class="messages error">'.$message['error'][0].'</div>';
      }
      if(isset($message['status']))
      {
        print '<div class="messages status">'.nl2br($message['status'][0]).'</div>';
      }
  }
  ?>

  <?php if ($use_issue_link && $newsletter_link): ?>
    <div class="issues-link"><?php print $newsletter_link; ?></div>
  <?php endif; ?>

  <?php if ($use_issue_list && $issue_list): ?>
    <div class="issues-list"><?php print $issue_list; ?></div>
  <?php endif; ?>

  <?php if ($use_rss): ?>
    <?php print $rssfeed; ?>
  <?php endif; ?>
    
    <div class="slogan_campagne">
      <img src="<?php print $base_url.'/'.path_to_theme(); ?>/images/slogan-campagne.png" alt="Un nouveau départ pour Toulouse" />
    </div><!-- Fin slogan_campagne -->

</div><!-- Fin popup_newsletter -->