<?php

/*
 * Permet de choisir et d'ajouter un fond d'écran
 * @author Comevents (Adrien)
 */

if (!defined('_PS_VERSION_')) {
  exit;
}

class OperationBackground extends Module {

  // Informations sur le module
  public function __construct() {
    $this->name = 'operationbackground';
    $this->tab = 'OperationBackground';
    $this->version = "1.1";
    $this->author = 'Comevents (Adrien)';
    $this->need_instance = 0;
    $this->bootstrap = true;
    parent::__construct();
    $this->displayName = $this->l('Operation Background');
    $this->description = $this->l('Permet de modifier l\'arrière plan');
    $this->confirmUninstall = $this->l('Delete this module ?');
  }

  // Setup
  public function install() {
    // Set hooks
    if (!parent::install() || !$this->registerHook('header')) {
      return false;
    } else {
      return true;
    }
  }

  // Add css and js
  public function hookHeader($params) {
    Tools::addCSS(( $this->_path ) . 'css/operationbackground.css', 'all');
  }

  /*
   * Vue
   * TODO assigner à un template
   */

  public function getContent() {
    $this->choixFondEcran();
    $this->_html.= '
			<link href="' . $this->_path . 'css/admin.css' . '" type="text/css" media="all" />
        
      <div class="alert alert-info" role="alert">
        <p>Suivant votre navigateur vous devrez certainement vider votre cache pour observer le changement sur votre site. (CTRL + F5)</p>
      </div>
        
      <h2>Choisissez votre fond d\'écran</h2>
      
			<form id="background_settings"  method="post" action="' . $_SERVER['REQUEST_URI'] . '" enctype="multipart/form-data">
         <ul class="list-inline">
            <li>
              <img style="width: 140px; height: 140px;" alt="Generic placeholder image" src="/modules/operationbackground/img/background.jpg" class="img-circle">
              <div class="radio">
                <label>
                  <input type="radio" name="background" value="defaut" checked> Fond d\'écran par défaut
                </label>
              </div>
            </li>
            <li>
              <img style="width: 140px; height: 140px;" alt="Generic placeholder image" src="/modules/operationbackground/img/background_blanc.jpg" class="img-circle">
              <div class="radio">
                <label>
                  <input type="radio" name="background" value="blanc"> Blanc
                </label>
              </div>
            </li>
            <li>
              <img style="width: 140px; height: 140px;" alt="Generic placeholder image" src="/modules/operationbackground/img/background_solde.jpg" class="img-circle">
              <div class="radio">
                <label>
                  <input type="radio" name="background" value="solde"> Période de soldes
                </label>
              </div>
            </li>
          </ul>
        <br>
        <input type="submit" name="save" value="Enregistrer" class="btn btn-success"/>
      </form>
			';
    return $this->_html;
  }

  private function ecrireCss($img) {
    // Mise à jour du css
    $css_file = dirname(__FILE__) . '/css/operationbackground.css';
    $handle = fopen($css_file, 'w');
    $style = "html,body{ background-color:black; }";
    $style = "html,body{background: #FFFFFF url( '/modules/operationbackground/img/" . $img . ".jpg' ) center center no-repeat; background-attachment:fixed; }";
    fwrite($handle, $style);
    fclose($handle);

    // ------------------------------------------
    $this->_html .= "
          <div class='alert alert-success' role='alert'>
            <p>Fond d'écran mis à jour sur le front office</p>
          </div>
        ";
  }

  /**
   * Permet de définir le fond d'écran en fonction du choix de l'utilisateur 
   */
  private function choixFondEcran() {
    if (Tools::isSubmit('save')) {
      switch ($_POST['background']) {
        case 'defaut':
          $this->ecrireCss('background');
          break;
        case 'blanc':
          $this->ecrireCss('background_blanc');
          break;
        case 'solde':
          $this->ecrireCss('background_solde');
          break;
      }
    }
  }

}

?>