<?php
/*
*  @author Comevents (Adrien)
*/
Class Product extends ProductCore
{
  
  /** @var boolean vente_flash */
	public $vente_flash = false;
  
  
  // On récupère les attributs de l'entité Produit via le constructeur
  public function __construct($id_product = null, $full = false, $id_lang = null, $id_shop = null, Context $context = null)
  {
      Product::$definition['fields']['vente_flash'] = array('type' => self::TYPE_BOOL, 'shop' => true, 'validate' => 'isBool');
      parent::__construct($id_product, $full, $id_lang, $id_shop, $context);
  }
  
  // A partir de là on ajoute les nouveaux attribut de l'entité produit
  
  // ================================================== Produit Similaire ==================================================
  
  /**
	 * Delete similar products
	 *
	 * @return mixed Deletion result
	 */
	public function deleteSimilars()
	{
		return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'similar` WHERE `id_product_1` = '.(int)$this->id);
	}

	/**
	 * Delete product from other similar products
	 *
	 * @return mixed Deletion result
	 */
	public function deleteFromSimilar()
	{
		return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'similar` WHERE `id_product_2` = '.(int)$this->id);
	}

	/**
	 * Get similar products (only names)
	 *
	 * @param integer $id_lang Language id
	 * @param integer $id_product Product id
	 * @return array Similar products
	 */
	public static function getSimilarsLight($id_lang, $id_product, Context $context = null)
	{
		if (!$context)
			$context = Context::getContext();

		$sql = 'SELECT p.`id_product`, p.`reference`, pl.`name`
				FROM `'._DB_PREFIX_.'similar`
				LEFT JOIN `'._DB_PREFIX_.'product` p ON (p.`id_product`= `id_product_2`)
				'.Shop::addSqlAssociation('product', 'p').'
				LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (
					p.`id_product` = pl.`id_product`
					AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl').'
				)
				WHERE `id_product_1` = '.(int)$id_product;

		return Db::getInstance()->executeS($sql);
	}

	/**
	 * Get similar products
	 *
	 * @param integer $id_lang Language id
	 * @return array Similar products
	 */
	public function getSimilar($id_lang, $active = true, Context $context = null)
	{
		if (!$context)
			$context = Context::getContext();

		$sql = 'SELECT p.*, product_shop.*, stock.out_of_stock, IFNULL(stock.quantity, 0) as quantity, pl.`description`, pl.`description_short`, pl.`link_rewrite`,
					pl.`meta_description`, pl.`meta_keywords`, pl.`meta_title`, pl.`name`, pl.`available_now`, pl.`available_later`,
					MAX(image_shop.`id_image`) id_image, il.`legend`, m.`name` as manufacturer_name, cl.`name` AS category_default,
					DATEDIFF(
						p.`date_add`,
						DATE_SUB(
							NOW(),
							INTERVAL '.(Validate::isUnsignedInt(Configuration::get('PS_NB_DAYS_NEW_PRODUCT')) ? Configuration::get('PS_NB_DAYS_NEW_PRODUCT') : 20).' DAY
						)
					) > 0 AS new
				FROM `'._DB_PREFIX_.'similar`
				LEFT JOIN `'._DB_PREFIX_.'product` p ON p.`id_product` = `id_product_2`
				'.Shop::addSqlAssociation('product', 'p').'
				LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (
					p.`id_product` = pl.`id_product`
					AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl').'
				)
				LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (
					product_shop.`id_category_default` = cl.`id_category`
					AND cl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('cl').'
				)
				LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_product` = p.`id_product`)'.
				Shop::addSqlAssociation('image', 'i', false, 'image_shop.cover=1').'
				LEFT JOIN `'._DB_PREFIX_.'image_lang` il ON (i.`id_image` = il.`id_image` AND il.`id_lang` = '.(int)$id_lang.')
				LEFT JOIN `'._DB_PREFIX_.'manufacturer` m ON (p.`id_manufacturer`= m.`id_manufacturer`)
				'.Product::sqlStock('p', 0).'
				WHERE `id_product_1` = '.(int)$this->id.
				($active ? ' AND product_shop.`active` = 1 AND product_shop.`visibility` != \'none\'' : '').'
				GROUP BY product_shop.id_product';

		if (!$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql))
			return false;
		foreach ($result as &$row)
			$row['id_product_attribute'] = Product::getDefaultAttribute((int)$row['id_product']);
		return $this->getProductsProperties($id_lang, $result);
	}

	public static function getSimilarById($similar_id)
	{
		return Db::getInstance()->getRow('SELECT `id_product`, `name` FROM `'._DB_PREFIX_.'product_lang` WHERE `id_product` = '.(int)$similar_id);
	}

	/**
	 * Link similar products with product
	 *
	 * @param array $similarproducts_id Similar ids
	 */
	public function changeSimilars($similarproducts_id)
	{
		foreach ($similarproducts_id as $id_product_2)
			Db::getInstance()->insert('similar', array(
				'id_product_1' => (int)$this->id,
				'id_product_2' => (int)$id_product_2
			));
	}
  
    public static function duplicateSimilars($id_product_old, $id_product_new)
    {
      $return = true;

      $result = Db::getInstance()->executeS('
      SELECT *
      FROM `'._DB_PREFIX_.'similar`
      WHERE `id_product_1` = '.(int)$id_product_old);
      foreach ($result as $row)
      {
        $data = array(
          'id_product_1' => (int)$id_product_new,
          'id_product_2' => (int)$row['id_product_2']);
        $return &= Db::getInstance()->insert('similar', $data);
      }
      return $return;
    }
    
    /**
	* Webservice getter : get product similars ids of current product for association
	*
	* @return array
	*/
	public function getWsSimilars()
	{
		$result = Db::getInstance()->executeS(
			'SELECT p.`id_product` AS id
			FROM `'._DB_PREFIX_.'similar` a
			LEFT JOIN `'._DB_PREFIX_.'product` p ON (p.id_product = a.id_product_2)
			'.Shop::addSqlAssociation('product', 'p').'
			WHERE a.`id_product_1` = '.(int)$this->id
		);

		return $result;
	}
	
	/**
	* Webservice setter : set product similars ids of current product for association
	*
	* @param $similars product ids
	*/
	public function setWsSimilars($similars)
	{
		$this->deleteSimilars();
		foreach ($similars as $similar) 
			Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.'similar` (`id_product_1`, `id_product_2`) VALUES ('.(int)$this->id.', '.(int)$similar['id'].')');
		
		return true;
	}
  
  // ================================================== FIN Produit Similaire ==================================================
  
  // ================================================== Produit de remplacement ==================================================

  /**
  * Delete substitution products
  *
  * @return mixed Deletion result
  */
  public function deleteSubstitutions()
  {
    return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'substitution` WHERE `id_product_1` = '.(int)$this->id);
  }

  /**
  * Delete product from other substitution products
  *
  * @return mixed Deletion result
  */
  public function deleteFromSubstitution()
  {
    return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'substitution` WHERE `id_product_2` = '.(int)$this->id);
  }

  /**
  * Get substitution products (only names)
  *
  * @param integer $id_lang Language id
  * @param integer $id_product Product id
  * @return array Substitution products
  */
  public static function getSubstitutionsLight($id_lang, $id_product, Context $context = null)
  {
    if (!$context)
      $context = Context::getContext();

    $sql = 'SELECT p.`id_product`, p.`reference`, pl.`name`
        FROM `'._DB_PREFIX_.'substitution`
        LEFT JOIN `'._DB_PREFIX_.'product` p ON (p.`id_product`= `id_product_2`)
        '.Shop::addSqlAssociation('product', 'p').'
        LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (
          p.`id_product` = pl.`id_product`
          AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl').'
        )
        WHERE `id_product_1` = '.(int)$id_product;

    return Db::getInstance()->executeS($sql);
  }

  /**
  * Get substitution products
  *
  * @param integer $id_lang Language id
  * @return array Substitution products
  */
  public function getSubstitution($id_lang, $active = true, Context $context = null)
  {
    if (!$context)
      $context = Context::getContext();

    $sql = 'SELECT p.*, product_shop.*, stock.out_of_stock, IFNULL(stock.quantity, 0) as quantity, pl.`description`, pl.`description_short`, pl.`link_rewrite`,
          pl.`meta_description`, pl.`meta_keywords`, pl.`meta_title`, pl.`name`, pl.`available_now`, pl.`available_later`,
          MAX(image_shop.`id_image`) id_image, il.`legend`, m.`name` as manufacturer_name, cl.`name` AS category_default,
          DATEDIFF(
            p.`date_add`,
            DATE_SUB(
              NOW(),
              INTERVAL '.(Validate::isUnsignedInt(Configuration::get('PS_NB_DAYS_NEW_PRODUCT')) ? Configuration::get('PS_NB_DAYS_NEW_PRODUCT') : 20).' DAY
            )
          ) > 0 AS new
        FROM `'._DB_PREFIX_.'substitution`
        LEFT JOIN `'._DB_PREFIX_.'product` p ON p.`id_product` = `id_product_2`
        '.Shop::addSqlAssociation('product', 'p').'
        LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (
          p.`id_product` = pl.`id_product`
          AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl').'
        )
        LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (
          product_shop.`id_category_default` = cl.`id_category`
          AND cl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('cl').'
        )
        LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_product` = p.`id_product`)'.
        Shop::addSqlAssociation('image', 'i', false, 'image_shop.cover=1').'
        LEFT JOIN `'._DB_PREFIX_.'image_lang` il ON (i.`id_image` = il.`id_image` AND il.`id_lang` = '.(int)$id_lang.')
        LEFT JOIN `'._DB_PREFIX_.'manufacturer` m ON (p.`id_manufacturer`= m.`id_manufacturer`)
        '.Product::sqlStock('p', 0).'
        WHERE `id_product_1` = '.(int)$this->id.
        ($active ? ' AND product_shop.`active` = 1 AND product_shop.`visibility` != \'none\'' : '').'
        GROUP BY product_shop.id_product';

    if (!$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql))
      return false;
    foreach ($result as &$row)
      $row['id_product_attribute'] = Product::getDefaultAttribute((int)$row['id_product']);
    return $this->getProductsProperties($id_lang, $result);
  }

  public static function getSubstitutionById($substitution_id)
  {
    return Db::getInstance()->getRow('SELECT `id_product`, `name` FROM `'._DB_PREFIX_.'product_lang` WHERE `id_product` = '.(int)$substitution_id);
  }

  /**
  * Link substitution products with product
  *
  * @param array $substitutionproducts_id Substitution ids
  */
  public function changeSubstitutions($substitutionproducts_id)
  {
    foreach ($substitutionproducts_id as $id_product_2)
      Db::getInstance()->insert('substitution', array(
        'id_product_1' => (int)$this->id,
        'id_product_2' => (int)$id_product_2
      ));
  }

    public static function duplicateSubstitutions($id_product_old, $id_product_new)
    {
      $return = true;

      $result = Db::getInstance()->executeS('
      SELECT *
      FROM `'._DB_PREFIX_.'substitution`
      WHERE `id_product_1` = '.(int)$id_product_old);
      foreach ($result as $row)
      {
        $data = array(
          'id_product_1' => (int)$id_product_new,
          'id_product_2' => (int)$row['id_product_2']);
        $return &= Db::getInstance()->insert('substitution', $data);
      }
      return $return;
    }

    /**
  * Webservice getter : get product substitutions ids of current product for association
  *
  * @return array
  */
  public function getWsSubstitutions()
  {
    $result = Db::getInstance()->executeS(
      'SELECT p.`id_product` AS id
      FROM `'._DB_PREFIX_.'substitution` a
      LEFT JOIN `'._DB_PREFIX_.'product` p ON (p.id_product = a.id_product_2)
      '.Shop::addSqlAssociation('product', 'p').'
      WHERE a.`id_product_1` = '.(int)$this->id
    );

    return $result;
  }

  /**
  * Webservice setter : set product substitutions ids of current product for association
  *
  * @param $substitutions product ids
  */
  public function setWsSubstitutions($substitutions)
  {
    $this->deleteSubstitutions();
    foreach ($substitutions as $substitution) 
      Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.'substitution` (`id_product_1`, `id_product_2`) VALUES ('.(int)$this->id.', '.(int)$substitution['id'].')');

    return true;
  }

  // ================================================== FIN Produit de remplacement ==================================================
  
}