<?php
/*
*  @author Comevents (Adrien)
*/
class ContactController extends ContactControllerCore
{
	
	// On surcharge la fonction initContent pour pouvoir envoyer à la vue les produits similaires
  public function initContent(){
    
    if(!empty($_POST)){ 
      $products_string = substr($_POST['products'], 0, -1); 
      $products_id = explode(";", $products_string);

      $products = array();
      foreach($products_id as $product_id){
        $product = new Product($product_id, false, null);
        array_push($products, $product);
      }
      /*
      foreach($products as $product){
        print '<pre>';
        print_r($product);
        print '</pre>';
      }*/

      $message_devis = "";
      if(count($products)>0){
        $message_devis .= "Bonjour,\n";
        $message_devis .= "Je souhaiterai avoir un devis pour le panier suivant:\n";
        foreach($products as $product){
          $message_devis .= " - Nom: ".$product->name[1]." (réf: $product->reference)\n";
        }
        $message_devis .= "\nCordialement,\n";
        $message_devis .= "[VOTRE NOM] [Votre Prénom]\n";
      }

      $this->context->smarty->assign(array(
          'products' => $products,
          'message_devis' => $message_devis,
      ));
    }
    
    $service_client=false;
    if(!empty($_GET)){
      if($_GET['objet']=='service-client'){
        $service_client=true;
      }
    }
    $this->context->smarty->assign(array(
        'service_client' => $service_client,
    ));
    
    parent::initContent();
  }

}